<?php
require '../assets/config-data.php';

// Prepare and bind
$stmt = $data->prepare("SELECT * FROM keluhan_member WHERE kode_keluhan = ?");
$stmt->bind_param("s", $kodekeluhan);

// Sanitize the input
$kodekeluhan = mysqli_real_escape_string($data, $_GET['kode']);
$stmt->execute();
$qkeluhan = $stmt->get_result();

if ($qkeluhan->num_rows > 0) {
    // Prepare and bind for second query
    $stmtKas = $data->prepare("SELECT user_keluhan FROM kasus_keluhan WHERE kode_kasus = ?");
    $stmtKas->bind_param("s", $kodekeluhan);
    $stmtKas->execute();
    $qkas = $stmtKas->get_result();
    $fkas = $qkas->fetch_assoc();

    echo '<input type="hidden" name="kodehid" value="' . htmlspecialchars($kodekeluhan) . '" />
          <input type="hidden" name="userhid" value="' . htmlspecialchars($fkas['user_keluhan']) . '" />';

    while ($fkeluhan = $qkeluhan->fetch_assoc()) {
        $sender = $fkeluhan['sender_keluhan'];
        $receiver = $fkeluhan['receiver_keluhan'];
        $message = $fkeluhan['msg_keluhan'];
        $tglkelu = $fkeluhan['tgl_keluhan'];
        $baca = $fkeluhan['baca_keluhan'];

        if ($sender) {
            echo '<div class="d-flex justify-content-start">
                    <div style="width: 350px;">
                        <h6 class="m-0 text-capitalize p-0">' . htmlspecialchars($sender) . ' #' . htmlspecialchars($kodekeluhan) . '</h6>';
            if ($baca == '0') {
                echo '<span class="badge bg-danger text-light blinks">BARU</span>';
            }
            echo '<p style="font-size: 0.6rem; color : #715600;" class="m-0 mb-1 p-0"><i class="fas fa-clock"></i> ' . date("d M Y H:i:s", strtotime($tglkelu)) . '</p>
                  <p style="background-color: #e7e7e7;" class="rounded p-2">' . htmlspecialchars($message) . '</p>
                  </div>
                </div>';
        } else {
            echo '<div class="d-flex justify-content-end">
                    <div class="text-right" style="width: 350px;">
                        <h6 class="m-0 text-capitalize p-0">' . htmlspecialchars($receiver) . '</h6>
                        <p style="font-size: 0.6rem;" class="text-secondary m-0 mb-1 p-0"><i class="fas fa-clock"></i> ' . date("d M Y H:i:s", strtotime($tglkelu)) . '</p>
                        <p style="background-color: #e7e7e7;" class="rounded p-2">' . htmlspecialchars($message) . '</p>
                    </div>
                </div>';
        }
    }
} else {
    echo '<p class="text-danger fw-bold">Kode Keluhan tidak ditemukan!!. Mohon diperiksa kembali kode yang dimasukkan.</p>
          <p class="text-danger">Pastikan ada tanda <strong>#</strong> diawal kode misal: #123456</p>';
}

$stmt->close();
$stmtKas->close();
