<?php
    require 'assets/data.php';
    require 'assets/config.php';
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo ftab("seo_title", "setting_website", "seo_title") ?></title>
    <meta content='<?php echo ftab("seo_desc", "setting_website", "seo_desc") ?>' name='description'/>
    <meta content='<?php echo ftab("seo_keyword", "setting_website", "seo_keyword") ?>' name='keywords'/>
    <meta content='<?php echo ftab("seo_title", "setting_website", "seo_title") ?>' name='author'/>
    <meta content='<?php echo ftab("seo_title", "setting_website", "seo_title") ?>' property='og:title'/>
    <meta content='<?php echo ftab("seo_desc", "setting_website", "seo_desc") ?>' property='og:description'/>
    <meta content='<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]"; ?>' property='og:url'/>
    <meta content='<?php echo ftab("seo_title", "setting_website", "seo_title") ?>' property='og:site_name'/>
    <meta content='<?php echo ftab("seo_img", "setting_website", "seo_img") ?>' property='og:image'/>
    <meta content='website' property='og:type'/>
    <meta content='follow, all' name='Googlebot-Image'/>
    <meta content='follow, all' name='Scooter'/>
    <meta content='follow, all' name='msnbot'/>
    <meta content='follow, all' name='alexabot'/>
    <meta content='follow, all' name='ZyBorg'/>
    <meta content='follow, all' name='yahoobot'/>
    <meta content='follow, all' name='bingbot'/>
    <meta content='index, follow' name='robots'/>
    <meta content='1 days' name='revisit-after'/>
    <meta content='general' name='rating'/>
    <meta content='id' name='geo.country'/>
    <meta content='Indonesia' name='geo.placename'/>
    <meta content='id' name='language'/>
    <meta content='never' name='expires'/>
    <meta content='ALL' name='SPIDERS'/>
    <meta content='ALL' name='WEBCRAWLERS'/>
    <meta content='global' name='distribution'/>

    <link href='<?php echo (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]"; ?>' rel='canonical'/>
    <link rel="icon" type="image/png" href="<?php echo ftab("seo_fav", "setting_website", "seo_fav") ?>"/>

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css" integrity="sha384-lZN37f5QGtY3VHgisS14W3ExzMWZxybE1SJSEsQp9S+oqd12jhcu+A56Ebc1zFSJ" crossorigin="anonymous">
    <link rel="stylesheet" href="css/app-keluhan.css">
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/jquery.datetimepicker.min.css">

    <style>
        body{
            background: url("<?php echo ftab("web_bg", "setting_website", "web_bg") ?>");
            background-size: cover !important;
            background-attachment: fixed !important;
            background-position-x: center !important;
            background-position-y: center !important;
        }
        .app-theme {
            background: <?php echo ftab("warna_bg", "setting_website", "warna_bg") ?>;
        }

        .border-teks {
            background: #eeeded;
            font-weight: bold;
            border: 2px solid #DBDBDB;
        }

        .border-theme {
            border: 4px solid <?php echo ftab("warna_bg", "setting_website", "warna_bg") ?>;
        }

        .app-theme-text, .besar-text span {
            color: <?php echo ftab("warna_tulis", "setting_website", "warna_tulis") ?> !important;
        }

        .besar-text {
            font-size: 2.3rem;
        }
    </style>

    <?php echo ftab("web_scripts", "setting_website", "web_scripts") ?>

</head>
<body>
    
<div class="d-flex align-items-center justify-content-center flex-column">
        <div class="box-keluhan">
                    <div class="logo">
                        <a href="<?php echo ftab("web_login", "setting_website", "web_login") ?>" target="_blank">
                        <img width="300" class="d-block mx-auto" src="<?php echo ftab("logo_web", "setting_website", "logo_web") ?>" alt="logo keluhan">
                        </a>
                    </div>

                    <div class="card border-theme">
                            <div class="card-header d-flex justify-content-between">
                                <div><i class="fas fa-user-astronaut"></i> <span id="title-keluhan">Laporkan Masalah</span></div>

                                    <button type="button" id="btnInbox" onclick="actionKeluhan()" class="btn fw-bold btn-danger">Inbox</button>
                            </div>

                                <div id="formInbox">
                                        <div class="card-body">
                                                <div class="row">
                                                        <div class="col-12">
                                                                <div id="content-keluhan">
                                                                    <h2 class="text-danger fw-bold">Isi Kode Keluhan</h2>
                                                                    <p>Silahkan di isi kode keluhan agar terlihat respon dari admin kami. Terima kasih</p>
                                                                </div>
                                                        </div>
                                                </div>
                                        </div>

                                        <div class="card-footer">
                                                <div class="d-grid">
                                                    <form id="inboxSend">
                                                        <div class="input-group mb-2">
                                                        <input type="text" name="kodekeluhan" id="kodekeluhan" onkeyup="findKeluhan(); this.value = this.value.replace(/[^0-9A-Za-z#]/g, '')" class="form-control" placeholder="Kode Keluhan Contoh : #1947582" />
                                                        <button type="button" onclick="removeKode()" class="btn btn-danger"><i class="fas fa-times"></i></button>
                                                        </div>

                                                        <div class="input-group mb-3">
                                                            <input type="file" class="form-control" name="sendgambar" id="sendgambar">
                                                            <label class="input-group-text" for="gambar"><i class="fas fa-image"></i></label>
                                                        </div>

                                                    <input type="text" name="kotakpesan" placeholder="Isi Pesan.." id="kotakpesan" class="form-control form-control-lg mb-2" />
                                                        <div class="d-grid">
                                                        <button type="button" id="sendInbox" class="btn btn-success">Send</button>
                                                        </div>
                                                    </form>
                                                </div>
                                        </div>
                                </div>

                                <div id="loadingkeluhan" class="text-center p-3">
                                    <div class="spinner-border text-warning" role="status">
                                        <span class="visually-hidden">Loading...</span>
                                    </div>
                                    <h3>Mohon ditunggu...</h3>
                                    <p>Jangan direfresh agar tidak terjadi kesalahan saat mengirim.</p>
                                    <p style="font-size: 0.7rem !important; font-style:italic;">Biasanya Bila lama kerena gambar yang dikirim sangat besar.</p>
                                </div>

                            <form id="formKeluhan">

                            <div class="card-body">
                                    <?php
                                        $smar = "SELECT * FROM pengumuman WHERE peng_status = '0' ORDER BY peng_date DESC";
                                        $qmar = mysqli_query($data, $smar);

                                        if(mysqli_num_rows($qmar) > 0) {
                                            echo '<div id="text-berjalan" class="position-relative">
                                            <i onclick="closeTeks()" class="fas fa-times-circle closeteks"></i>
                                            <marquee class="teks-berjalan app-theme-text border-teks mb-2" scrollamount="4" direction="left">';
                                                while($fmar = mysqli_fetch_assoc($qmar)) {
                                                    echo '<span class="badge bg-danger">'.$fmar['peng_date'].'</span> ['.$fmar['peng_desc'].'] ';
                                                }
                                            
                                            echo '</marquee>
                                            </div>';
                                        }
                                    ?>

                                        <div class="row g-2">
                                                <div class="col-6">
                                                    <div class="input-group">
                                                        <span class="input-group-text"><i class="fas fa-user"></i></span>
                                                        <input type="text" placeholder="Username" class="form-control" name="username" id="username">
                                                    </div>
                                                </div>

                                                <div class="col-6">
                                                    <div class="input-group">
                                                        <span class="input-group-text"><i class="fab fa-whatsapp"></i></span>
                                                        <input type="text" onkeyup="this.value = this.value.replace(/[^0-9]/g, '')" placeholder="Nomor WA aktif (cth: 0812364896)" class="form-control" name="wa" id="wa">
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="input-group">
                                                        <span class="input-group-text"><i class="fas fa-calendar-week"></i></span>
                                                        <input type="text" placeholder="Tanggal Kendala" onkeyup="this.value = this.value.replace(/[^0-9-]/g, '')" class="form-control" name="tanggalkendala" id="dateresult">
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="input-group">
                                                        <span class="input-group-text"><i class="fas fa-exclamation-triangle"></i></span>
                                                        <input type="text" placeholder="Kendala" class="form-control" name="kendala" id="kendala">
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="input-group">
                                                        <span class="input-group-text"><i class="fas fa-globe"></i></span>
                                                        <select name="bokendala" class="form-select text-capitalize" aria-label="Default select example">
                                                            <option value="">Pilih Situs BO</option>
                                                            <?php
                                                                $sbo = "SELECT bo_name, bo_slug FROM bo_info";
                                                                $qbo = mysqli_query($data, $sbo);

                                                                if(mysqli_num_rows($qbo) > 0) {
                                                                    while($fbo = mysqli_fetch_assoc($qbo)) {
                                                                        echo '<option value="'.$fbo['bo_slug'].'">'.$fbo['bo_name'].'</option>';
                                                                    }
                                                                }
                                                            ?>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div style="height:150px;" class="input-group">
                                                        <span class="input-group-text"><i class="fas fa-comments"></i></span>
                                                        <textarea class="form-control" id="isipesan" name="isipesan"></textarea>
                                                    </div>
                                                </div>

                                                <div class="col-12">
                                                    <div class="input-group">
                                                        <span class="input-group-text"><i class="fas fa-vote-yea"></i></span>
                                                        <select name="saran" id="saran" class="form-select">
                                                            <option value="normal">Normal</option>
                                                            <option value="sedang">Sedang</option>
                                                            <option value="tinggi">Tinggi</option>
                                                        </select>
                                                    </div>
                                                </div>

                                                <div class="input-group mb-3">
                                                    <input type="file" class="form-control" name="uploadfile" id="gambar">
                                                    <label class="input-group-text" for="gambar"><i class="fas fa-image"></i></label>
                                                </div>

                                        </div>
                            </div>

                            <div class="card-footer">
                                    <div class="d-grid">
                                        <button type="submit" id="sendKeluhan" class="btn bg-gradient fw-bold app-theme">Kirim</button>
                                    </div>
                            </div>
                    </div>

                    </form>
        </div> <!-- End Box Keluhan -->

                <div class="d-none">
                    <?php echo ftab("web_paraf", "setting_website", "web_paraf") ?>
                
                </div>


</div>

<!-- Show Keluhan -->
<div class="modal fade" id="showKeluhan" data-bs-backdrop="static" data-bs-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
  <div class="modal-dialog modal-fullscreen">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="staticBackdropLabel">Laporan Keluhan</h5>
      </div>

      <div class="modal-body">
            <div id="contentKeluhan"></div>
      </div>

      <div class="modal-footer">
        <button onclick="location.reload();" class="btn btn-danger"><i class="fas fa-times-circle"></i> Tutup</button>
      </div>

    </div>
  </div>
</div>


<script src="https://code.jquery.com/jquery-3.6.0.js" integrity="sha256-H+K7U5CnXl1h5ywQfKtSj8PCmoN9aaq30gDh27Xc0jk=" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.1/dist/umd/popper.min.js" integrity="sha384-9/reFTGAW83EW2RDu2S0VKaIzap3H66lZH81PoYlFhbGU+6BZp6G7niu735Sk7lN" crossorigin="anonymous"></script>
<script src="js/jquery.datetimepicker.full.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/app-keluhan.js"></script>
<?php echo ftab("web_scripts2", "setting_website", "web_scripts2") ?>

</body>
</html>